import React from 'react';
import { ImageOff } from 'lucide-react';

interface DocumentImageProps {
  src: string;
  onRetry: () => void;
}

export function DocumentImage({ src, onRetry }: DocumentImageProps) {
  const [error, setError] = React.useState(false);

  const handleError = () => setError(true);
  const handleRetry = () => {
    setError(false);
    onRetry();
  };

  if (error) {
    return (
      <div className="flex flex-col items-center justify-center h-96 bg-gray-100 rounded-lg">
        <ImageOff className="w-16 h-16 text-gray-400 mb-4" />
        <p className="text-gray-600 mb-4">Failed to load image</p>
        <button
          onClick={handleRetry}
          className="px-4 py-2 bg-blue-500 text-white rounded-md hover:bg-blue-600 transition-colors"
        >
          Retry
        </button>
      </div>
    );
  }

  return (
    <img
      src={src}
      alt="Document to categorize"
      className="max-h-96 w-full object-contain rounded-lg"
      onError={handleError}
    />
  );
}